VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fHelloWorld 
   Caption         =   "Simple SQL (dhSQLite)-Demo"
   ClientHeight    =   6780
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   9720
   LinkTopic       =   "Form1"
   ScaleHeight     =   6780
   ScaleWidth      =   9720
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton cmdSomeQueries 
      Caption         =   "Some SQL-Queries..."
      Height          =   405
      Left            =   210
      TabIndex        =   1
      Top             =   210
      Width           =   1725
   End
   Begin MSDataGridLib.DataGrid DataGrid1 
      Height          =   5835
      Left            =   180
      TabIndex        =   0
      Top             =   780
      Width           =   9345
      _ExtentX        =   16484
      _ExtentY        =   10292
      _Version        =   393216
      HeadLines       =   1
      RowHeight       =   15
      BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ColumnCount     =   2
      BeginProperty Column00 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   0
         EndProperty
      EndProperty
      BeginProperty Column01 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   0
         EndProperty
      EndProperty
      SplitCount      =   1
      BeginProperty Split0 
         BeginProperty Column00 
         EndProperty
         BeginProperty Column01 
         EndProperty
      EndProperty
   End
End
Attribute VB_Name = "fHelloWorld"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Very simple introducion into the dhSQLite-WrapperClasses
'(and also SQL as query-language)
'not relying on the regfree-mode of the toolset, to keep things simple
Option Explicit

Private Cnn As cConnection 'please associate a Cnn-Object with "TheDB"...
Private Rs As cRecordset '...and a Recordset with a "QueryResult-Matrix"


Private Sub Form_Load()
  'first the opening of a Connection-Object
  Set Cnn = New cConnection 'instantiate the Connection-Object
  Cnn.CreateNewDB 'create (associate) an InMemory-DB on that Connection

  'now create your first, simple Table on it (we simply name it T),
  'containing only three Columns (ID, Year, and Price)
  Cnn.Execute "Create Table T(ID Integer, Year Integer, Price Double)"

  'now insert some Data into T over an Insert-CommandObject
  Dim Cmd As cCommand
  'first we create the Command with a Cmd-Definition that
  'makes use of named parameters (one for each of our T-columns)
  Set Cmd = Cnn.CreateCommand("Insert Into T Values(@ID,@Year,@Price)")

  'now some Inserts (in a small loop)
  Dim ID As Long
  With Cmd
    For ID = 1 To 10 'we create 10 new records (rows) on Table T
      'first fill the CmdObject with the current column-values
      .SetInt32 !ID, ID
      .SetInt32 !Year, 2005 + ((ID - 1) Mod 5)
      .SetDouble !Price, (ID * 10)

      .Execute 'and that beams the current record into T
    Next ID
  End With

  'Ok, done - we have created our first simple Table T,
  'defined with 3 named Columns (ID, Year, Price) - now
  'containing also 10 rows/records with table-data ...

  '------------------------------------------------------------
  'Now the Read-direction (over a Recordset)
  Dim Rs As cRecordset, SQL As String

  'the usual string, to select "everything" (all Columns
  'and all records) - resulting in the complete table-
  'content-representation in our "Rs-ResultMatrix"
  SQL = "Select * From T"

  Set Rs = Cnn.OpenRecordset(SQL) 'perform the query

  'after returning from a query, the Recordset-implementation
  'of my wrapper always contains the complete data as a
  'copy - there is no dynamic cursor which points to the
  'original table-records - everything the select-query
  'describes is always "completely contained" inside of the Rs

  '...so we can always rely on that - and therefore an
  'SQLite-Recordset can be treated also as a two-dimensional
  'array, accessible with Zerobased Row- and Column-indexes over
  'a special Property called: Rs.ValueMatrix(i, j)... This
  'property is not available on ADO or DAO, but very useful,
  'since it does not shift the Rs-internal RecordCursor - but
  'read further...

  'Ok, first ...even if a Rs does not contain any Data-Records
  '(testable with Rs.RecordCount = 0) - it contains at least
  'the Field- or Column-Infos, we make use of that fact - and
  'list one of the Field-Infos here (the FieldName)
  Dim i As Long, j As Long
  For j = 0 To Rs.Fields.Count - 1
    Debug.Print Rs.Fields(j).Name,
  Next j
  Debug.Print vbCrLf; "--------------------------------------"

  'now the content, dumped in an "array-like" way over Rs.ValueMatrix
  For i = 0 To Rs.RecordCount - 1
    For j = 0 To Rs.Fields.Count - 1
      Debug.Print Rs.ValueMatrix(i, j),
    Next j
    Debug.Print
  Next i

  'Ok, that was the indexbased access into the 2D-ResultSet
  'now the same Debug-Dump again using the internal Recordset-
  '"Cursor", which is shiftable "By Row" using the Move-Methods
  Debug.Print

  'first the Header-Dump on the Rs-Fields again - this time
  'in a somewhat different way, just for demonstration
  Dim Fld As cField
  For Each Fld In Rs.Fields
    Debug.Print Fld.Name,
  Next Fld
  Debug.Print vbCrLf; "--------------------------------------"

  'now the content again (in the same way as with ADO)
  Do Until Rs.EOF
    For Each Fld In Rs.Fields
      Debug.Print Fld.Value,
    Next Fld
    Debug.Print
    Rs.MoveNext
  Loop
End Sub

Private Sub cmdSomeQueries_Click()
Dim SQL As String
  'and here comes a short query-demonstration, what you can
  'do on the current content of table T (filtering, grouping)

  'first a query, which demonstrates something, the SQL-Query-
  'processor is able to do for you, even without addressing
  '(mentioning) any Tables (or column-data) in the Select
  SQL = "Select 1+2, 3*4, Format$(567, '#0.00'), Round(8.75, 1)"
  QueryAndBindRs SQL

  'Ok - on to Table T - first the complete "table-dump" -
  'containing all Columns and all Records
  SQL = "Select * From T"
  QueryAndBindRs SQL

  'here an example, how you can restrict the Columns from
  'a complete List (using *) to e.g. Year and Price only
  SQL = "Select Year, Price From T"
  QueryAndBindRs SQL

  'same thing again, but with an additionally calculated Field
  '(a discounted Price)
  SQL = "Select Year, Price, Price * (1 - 0.10) From T"
  QueryAndBindRs SQL

  'same thing again, but now with explicite "renaming" of
  'the calculated Field - and just for fun also a renaming
  'of an original table-field (Price As MyPrice)
  SQL = "Select Year, Price As MyPrice, " & _
                     "Price * (1 - 0.10) As DiscountedPrice From T"
  QueryAndBindRs SQL

  'and a String-Concat, combining all 3 Table-Columns into
  'a single "StringResult" (note the || operator which does
  'the same as VBs & operator)
  SQL = "Select ID || '_' || Year || '_' || Price As StrConcat From T"
  QueryAndBindRs SQL

  'now your first, very simple filter
  '(introducing the Where-Clause of a Select)
  SQL = "Select * From T Where ID >= 5"
  QueryAndBindRs SQL

  'just another filter - which also shows, how you have
  'to enclose Strings within an SQL-Expression: '5'
  SQL = "Select * From T Where Right$(Year,1)='5'"
  QueryAndBindRs SQL

  'now a "Between .. And" filter to query a range
  SQL = "Select * From T Where (ID Between 2 And 8)"
  QueryAndBindRs SQL

  'this here is just the equivalent to the above query
  SQL = "Select * From T Where (ID >= 2 And ID <=8)"
  QueryAndBindRs SQL

  'and since we are at the IDs, here comes a comparison
  'against a "comma-separated List" (using the In Keyword)
  SQL = "Select * From T Where ID In (1,3,5,6,8)"
  QueryAndBindRs SQL

  'Ok, now to some more advanced stuff - aggregate
  'queries, which perform a grouping - and you
  'can define the math-operation which has to be
  'performed on a similar group - here we group
  'over the year-column, since I ensured (over the
  'insert-loop), that we have Year-pairs (which
  'gives two similar years in each group)

  'first a simple Count-Aggregate
  SQL = "Select Year, Count(Year) From T Group By Year"
  QueryAndBindRs SQL

  'now we enhance the above about a Sum-Aggregate for the IDs
  SQL = "Select Year, Count(Year), Sum(ID) From T Group By Year"
  QueryAndBindRs SQL

  'now instead of the Sum-Aggregate an Avg() on the Price-Column
  SQL = "Select Year, Count(Year), Avg(Price) From T Group By Year"
  QueryAndBindRs SQL

  'and to end this small "excursus", the above query again
  'with a restriction to a "range of years" (2006-2008 only)
  SQL = "Select Year, Count(Year), Avg(Price) From T " & _
        "Where Year Between 2006 And 2008 " & _
        "Group By Year"
  QueryAndBindRs SQL
End Sub

Private Sub QueryAndBindRs(SQL As String)
  Set DataGrid1.DataSource = Nothing
  Set Rs = Cnn.OpenRecordset(SQL)
  Set DataGrid1.DataSource = Rs.DataSource
  MsgBox SQL
End Sub

